from music21 import *
import os
import pickle
import copy
import glob
import sys
from shutil import copy, copyfile
#exec(open("genmeasures.py").read())


folder = "essen"
tot_songs = 0
files = [i for i in list(os.walk("./" + folder))[0][2] if i.endswith("xml")] #get filenames
songs = []
index = 0
bars = []
n_meas = 16

for (file_ind, file) in enumerate(files):
        notes = []
        a = converter.parse(folder + "/" + file) #parse with music21
        for val in list(a):
            if type(val) == stream.Part:
                for (el_ind, el) in enumerate(list(val)):
                    if type(el) == stream.Measure:
                        meas = []
                        for (el2_ind, el2) in enumerate(el):
                            if type(el2) == note.Rest:
                                meas.append((0, el2.quarterLength, 0, None, None))
                            elif type(el2) == note.Note:
                                meas.append((el2.pitch.midi, el2.quarterLength, el2.pitch.octave, el2.tie, el2.duration.tuplets))
                            else:
                                pass
                        if sum([q[1] for q in meas]) == 4.0:
                            #print(index)
                            #el.write(fmt="mid", fp="../data/essenbars/" + str(index) + ".mid")
                            index += 1
                            notes.append(meas)
                            bars.append(meas)
                
        if len(notes) >= n_meas:
            tot_songs += 1
            songs.append(notes[:n_meas]) #remove [:n_meas] for larger songs'

pickle.dump(bars, open("pickles/allbars.pcl", "wb"))

pickle.dump(songs, open("pickles/meas16.pcl", "wb"))
